dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 3, 250, 230, "assets/images/table/cruise", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 2, 220, 360, "assets/images/table/cruise_2", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 2, 370, 360, "assets/images/table/cruise_2", "assets/images/food/item_mark1", "R" );
LManager:AddNewTable( 4, 3, 250, 485, "assets/images/table/cruise", "assets/images/food/item_mark4", "R" );

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1

guest = LManager.GenGuest(uncle);
guest.matchType = table2;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);


-- Group 2

guest = LManager.GenGuest(uncle);
guest.matchType = table4;
guest.percentRequestCoffee = 50;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = NOT_GUEST + uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 7, 24000);

-- Group 3

guest = LManager.GenGuest(male02);
guest.matchType = female03;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(8, 9, 55000);


-- Group 4

guest = LManager.GenGuest(male02);
guest.matchType = aunt;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + uncle;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = NOT_TABLE + table1;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(10, 12, 90000);

-- Group 5

guest = LManager.GenGuest(female02);
guest.matchType = table1;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(13, 14, 120000);

-- Group 6

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 15, 140000);

-- Group 7

guest = LManager.GenGuest(female03);
guest.matchType = table4;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 17, 150000);

-- Group 8

guest = LManager.GenGuest(female02);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 19, 160000);


LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("dogDelay", 75000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 100000 );


-- Set up the Level Settings
LManager:SetLevelNumber(3,4);
LManager:SetLevelScores(7500, 10000);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/Uptempo 1.ogg","assets/audio/music/new_dance_3.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );